import { VerdictType } from '../store/videos/types';

type AppealDataType = {
    attemptId: string,
    isValidAttemptId: boolean,
    email: string,
    isValidEmail: boolean,
    verdict: VerdictType
};

export function validateAppealData(data: AppealDataType): boolean {
    const { attemptId, email, isValidAttemptId, isValidEmail, verdict } = data;

    return Boolean(attemptId && email && isValidAttemptId && isValidEmail && verdict);
}
