import { cn } from '@bem-react/classname';
import React, { Component } from 'react';

import { Button, Link } from 'lego-on-react';

import StatisticsContainer from '../statisticsContainer/statisticsContainer';

import 'lego-on-react/src/components/button/button.css';
import 'lego-on-react/src/components/link/link.css';

import './agenciesStat.css';

interface IAgenciesStatProps {
    urlTemplate: string,
    lastSyncAgenciesDate: string,
    isRequestedUpdate: boolean,
    isError: boolean,
    updateStat(): void
}

const b = cn('AgenciesStat');

class AgenciesStat extends Component<IAgenciesStatProps> {
    public render() {
        const {
            isRequestedUpdate,
            lastSyncAgenciesDate,
            updateStat
        } = this.props;

        const lastUpdateDate = new Date(lastSyncAgenciesDate);

        return (
            <div className={b()}>
                <StatisticsContainer title="Статистика по агентствам">
                    <div className={b('Row')}>
                        <Button
                            theme="action"
                            size="m"
                            text="Скачать отчёт"
                            onClick={this._onDownloadClick}
                            />
                        <div className={b('Hint')}>
                            последнее обновление {lastUpdateDate.toLocaleString()}
                        </div>
                    </div>
                    <div className={b('Row')}>
                        <Button
                            theme="normal"
                            size="m"
                            text="Обновить данные"
                            disabled={isRequestedUpdate}
                            onClick={updateStat}
                            />
                        <div className={b('Hint')}>
                            {'Письмо с результатами будет отправлено на '}
                            <Link
                                theme="normal"
                                text="adv-expert-agency"
                                url="https://ml.yandex-team.ru/lists/adv-expert-agency/"
                                />
                            {' в течение 1 часа'}
                        </div>
                        {
                            isRequestedUpdate &&
                            <div className={b('Message')}>Обновление началось</div>
                        }
                    </div>
                </StatisticsContainer>
            </div>
        );
    }

    private readonly _onDownloadClick = () => {
        const { urlTemplate } = this.props;

        if (window) {
            window.location.href = urlTemplate;
        }
    }

}

export default AgenciesStat;
