import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from '../../store/index';

import { agenciesStatAction } from '../../store/agenciesStat/types';

import {
    updateStat
} from '../../store/agenciesStat/actions';

import AgenciesStat from './agenciesStat';

interface IStateProps {
    isRequestedUpdate: boolean,
    isError: boolean
}

interface IOwnProps {
    urlTemplate: string,
    lastSyncAgenciesDate: string
}

type AgenciesStatProps = IStateProps & IOwnProps;

interface IDispatchProps {
    updateStat(): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): AgenciesStatProps {
    const { isRequestedUpdate, isError } = state.agenciesStat;
    const { urlTemplate, lastSyncAgenciesDate } = ownProps;

    return { isRequestedUpdate, isError, urlTemplate, lastSyncAgenciesDate };
}

function mapDispatchToProps(dispatch: Dispatch<agenciesStatAction>): IDispatchProps {
    return bindActionCreators({
        updateStat
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps>(
    mapStateToProps,
    mapDispatchToProps
)(AgenciesStat);
