import React, { Component, Fragment, ComponentType } from 'react';
import Helmet from 'react-helmet';
import YandexFavicon from 'react-yandex-favicon';
import { Switch, Route } from 'react-router-dom';

import Header from 'client/components/header';
import Footer from 'client/components/footer';

import './index.css';

import IndexPage from 'client/pages/index';
import DevPage from 'client/pages/dev';
import AdminPage from 'client/pages/admin';
import ExamPage from 'client/pages/exam';
import VideosPage from 'client/pages/videos';
import NullifyPage from 'client/pages/nullify';
import BanPage from 'client/pages/ban';

interface IAppProps {
    data?: any
}

export default class App extends Component<IAppProps> {
    public render() {
        const { data = {} } = this.props;

        if (!data.base) {
            return null;
        }

        const {
            langdetect = {},
            adminData: { accessToPages }
        } = data;

        return (
            <Fragment>
                <YandexFavicon lang={langdetect.id} />
                <Helmet>
                    <html lang={langdetect.id} />
                </Helmet>

                <Header
                    userInfo={data.base.userInfo}
                    accessToPages={accessToPages}
                    />
                <div className="page">
                    <Switch>
                        <Route
                            exact path="/"
                            render={this._renderPage(IndexPage, { data })}
                            />
                        <Route
                            exact path="/admin"
                            render={this._renderPage(AdminPage, { data })}
                            />
                        <Route
                            exact path="/admin/:examIdentity"
                            render={this._renderPage(ExamPage, { data })}
                            />
                        <Route
                            exact path="/dev"
                            render={this._renderPage(DevPage, { data })}
                            />
                        <Route
                            exact path="/videos"
                            component={VideosPage}
                            />
                        <Route
                            exact path="/nullify"
                            component={NullifyPage}
                            />
                        <Route
                            exact path="/bans"
                            component={this._renderPage(BanPage, { data })}
                            />
                    </Switch>
                </div>
                <Footer start={2003} tld={data.tld} />
            </Fragment>
        );
    }

    private _renderPage<T>(Page: ComponentType<T>, props: T) {
        return () => <Page {...props} />;
    }
}
