import React from 'react';

import StatisticsContainer from '../statisticsContainer';
import StatisticsInput from '../statisticsInput';

export interface IAttemptByNumberProps {
    inputText: string,
    isValid?: boolean,
    hasFocus: boolean,
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void,
    onSubmit(): void
}

const AttemptByNumber = (props: IAttemptByNumberProps) => {
    const {
        inputText,
        hasFocus,
        isValid,
        typeAction,
        focus,
        blur,
        onSubmit
    } = props;

    return (
        <StatisticsContainer title="Получение данных о попытке">
            <StatisticsInput
                tip="Номер попытки"
                buttonText="Скачать отчёт"
                placeholder="12345"
                typeAction={typeAction}
                inputText={inputText}
                onSubmit={onSubmit}
                hasFocus={hasFocus}
                focus={focus}
                blur={blur}
                errorMessage={isValid ? undefined : 'Введите число'}
                />
        </StatisticsContainer>
    );
};

export default AttemptByNumber;
