import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import withStatistics from '../../enhancements/withStatistics';
import { ApplicationState } from '../../store/index';
import { ITypeAction } from '../../store/attemptByNumber/types';
import { typeAction, focus, blur } from '../../store/attemptByNumber/actions';

import AttemptByNumber, { IAttemptByNumberProps } from './attemptByNumber';

interface IStateProps {
    inputText: string,
    hasFocus: boolean,
    isValid?: boolean
}

interface IOwnProps {
    urlTemplate: string
}

type AttemptByNumberProps = IStateProps & IOwnProps;

interface IDispatchProps {
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): AttemptByNumberProps {
    const { inputText, isValid, hasFocus } = state.attemptByNumber;
    const { urlTemplate } = ownProps;

    return { inputText, isValid, hasFocus, urlTemplate };
}

function mapDispatchToProps(dispatch: Dispatch<ITypeAction>): IDispatchProps {
    return bindActionCreators({
        typeAction,
        focus,
        blur
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(withStatistics<IAttemptByNumberProps>({ queryParam: 'trialId' })(AttemptByNumber));
