import React from 'react';

import StatisticsContainer from '../statisticsContainer';
import StatisticsInput from '../statisticsInput';

export interface IAttemptsByLoginProps {
    inputText: string,
    isValid?: boolean,
    hasFocus: boolean,
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void,
    onSubmit(): void
}

const AttemptsByLogin = (props: IAttemptsByLoginProps) => {
    const {
        inputText,
        onSubmit,
        typeAction,
        hasFocus,
        isValid,
        focus,
        blur
    } = props;

    return (
        <StatisticsContainer title="Получение попыток пользователя по логину">
            <StatisticsInput
                buttonText="Скачать отчёт"
                tip="Логин пользователя"
                placeholder="imperator"
                errorMessage={isValid ? undefined : 'Введите логин'}
                inputText={inputText}
                hasFocus={hasFocus}
                typeAction={typeAction}
                onSubmit={onSubmit}
                focus={focus}
                blur={blur}
                />
        </StatisticsContainer>
    );
};

export default AttemptsByLogin;
