import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import withStatistics from '../../enhancements/withStatistics';
import { ApplicationState } from '../../store/index';
import { ITypeAction } from '../../store/attemptsByLogin/types';
import { typeAction, focus, blur } from '../../store/attemptsByLogin/actions';

import AttemptsByLogin, { IAttemptsByLoginProps } from './attemptsByLogin';

interface IStateProps {
    inputText: string,
    hasFocus: boolean,
    isValid?: boolean
}

interface IOwnProps {
    urlTemplate: string
}

type AttemptsByLoginProps = IStateProps & IOwnProps;

interface IDispatchProps {
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): AttemptsByLoginProps {
    const { inputText, isValid, hasFocus } = state.attemptsByLogin;
    const { urlTemplate } = ownProps;

    return { inputText, isValid, hasFocus, urlTemplate };
}

function mapDispatchToProps(dispatch: Dispatch<ITypeAction>): IDispatchProps {
    return bindActionCreators({
        typeAction,
        focus,
        blur
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(withStatistics<IAttemptsByLoginProps>({ queryParam: 'login' })(AttemptsByLogin));
