import { cn } from '@bem-react/classname';
import { classnames } from '@bem-react/classnames';
import React, { Component } from 'react';
import { IAttemptInfo } from 'client/store/nullifyAttempt/types';

import 'client/components/table/table.css';

const b = cn('AttemptsInfo');

interface AttemptsInfoProps {
    attemptsInfo: IAttemptInfo[]
}

class AttemptsInfo extends Component<AttemptsInfoProps> {
    public render() {
        const { attemptsInfo } = this.props;

        return (
            <table className={classnames(b(), cn('Table')())}>
                <thead>
                    <tr>
                        <th>id попытки</th>
                        <th>Логин пользователя</th>
                        <th>Слаг экзамена</th>
                        <th>Время старта</th>
                        <th>Аннулирована?</th>
                    </tr>
                </thead>
                <tbody>
                    { attemptsInfo.map(attemptInfo => {
                        const startedDate = new Date(attemptInfo.started);

                        return (
                            <tr key={attemptInfo.trialId}>
                                <td>{attemptInfo.trialId}</td>
                                <td>{attemptInfo.login}</td>
                                <td>{attemptInfo.trialTemplateSlug}</td>
                                <td>{startedDate.toLocaleString()}</td>
                                <td>{attemptInfo.nullified ? 'Да' : 'Нет'}</td>
                            </tr>
                        );
                    })}
                </tbody>
            </table>
        );
    }
}

export default AttemptsInfo;
