import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store/index';
import Dictionary from 'common/types/dictionary';

import {
    BansAction,
    IBanError,
    IAssociationsInfo
} from 'client/store/bans/types';

import {
    typeLoginAction,
    focusLogin,
    blurLogin,
    getBanInfo
} from 'client/store/bans/actions';

import IExam from 'common/types/exam';

import Ban from './ban';

interface IOwnProps {
    exams: IExam[],
    examsById: Dictionary<string>
}

interface IStateProps {
    login: string,
    hasFocusLogin: boolean,
    isValidLogin: boolean,
    isPending: boolean,
    requestError: IBanError | null,
    associationsInfo: IAssociationsInfo | null
}

type BanProps = IStateProps & IOwnProps;

interface IDispatchProps {
    typeLoginAction(inputText: string): void,
    focusLogin(): void,
    blurLogin(): void,
    getBanInfo(login: string): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): BanProps {
    const {
        login,
        hasFocusLogin,
        isValidLogin,
        isPending,
        requestError,
        associationsInfo
    } = state.bans;

    const { exams, examsById } = ownProps;

    return {
        login,
        hasFocusLogin,
        isValidLogin,
        isPending,
        requestError,
        associationsInfo,
        exams,
        examsById
    };
}

function mapDispatchToProps(dispatch: Dispatch<BansAction>): IDispatchProps {
    return bindActionCreators({
        typeLoginAction,
        focusLogin,
        blurLogin,
        getBanInfo
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(Ban);
