import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store/index';
import Dictionary from 'common/types/dictionary';
import { IDetailsError } from 'common/utils/error';

import {
    IGlobalUserInfo
} from 'client//store/bans/types';

import {
    BanFormAction,
    IBanPayload
} from 'client/store/banForm/types';

import {
    chooseExams,
    typeLogins,
    focusLogins,
    blurLogins,
    typeReason,
    focusReason,
    blurReason,
    toggleSuperban,
    pressBan,
    decline,
    ban
} from 'client/store/banForm/actions';

import {
    getBanInfo
} from 'client/store/bans/actions';

import BanForm from './banForm';

interface IOwnProps {
    examsById: Dictionary<string>,
    globalUserInfo: IGlobalUserInfo,
    bannedExamsIds: string[]
}

interface IStateProps {
    examsForBan: string[],
    logins: string,
    hasFocusLogins: boolean,
    isValidLogins: boolean,
    hasLogins: boolean,
    reason: string,
    hasFocusReason: boolean,
    isSuperban: boolean,
    isPending: boolean,
    requestError: IDetailsError | null,
    isBanSuccess: boolean,
    userLogin: string,
    isVisibleConfirmationModal: boolean,
    submitErrors: string[] | null
}

type BanFormProps = IStateProps & IOwnProps;

interface IDispatchProps {
    chooseExams(exams: string[]): void,
    typeLogins(inputText: string): void,
    focusLogins(): void,
    blurLogins(): void,
    typeReason(inputText: string): void,
    focusReason(): void,
    blurReason(): void,
    toggleSuperban(): void,
    pressBan(): void,
    decline(): void,
    ban(banData: IBanPayload): void,
    getBanInfo(login: string): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): BanFormProps {
    const {
        examsForBan,
        logins,
        hasFocusLogins,
        isValidLogins,
        hasLogins,
        reason,
        hasFocusReason,
        isSuperban,
        isPending,
        requestError,
        isBanSuccess,
        isVisibleConfirmationModal,
        submitErrors
    } = state.banForm;

    const { login: userLogin } = state.bans;

    const { examsById, globalUserInfo, bannedExamsIds } = ownProps;

    return {
        examsForBan,
        logins,
        hasFocusLogins,
        isValidLogins,
        hasLogins,
        reason,
        hasFocusReason,
        isSuperban,
        isPending,
        requestError,
        isBanSuccess,
        examsById,
        globalUserInfo,
        userLogin,
        isVisibleConfirmationModal,
        submitErrors,
        bannedExamsIds
    };
}

function mapDispatchToProps(dispatch: Dispatch<BanFormAction>): IDispatchProps {
    return bindActionCreators({
        chooseExams,
        typeLogins,
        focusLogins,
        blurLogins,
        typeReason,
        focusReason,
        blurReason,
        toggleSuperban,
        ban,
        getBanInfo,
        pressBan,
        decline
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps>(
    mapStateToProps,
    mapDispatchToProps
)(BanForm);
