import { cn } from '@bem-react/classname';
import React, { Component } from 'react';
import { stringify } from 'query-string';

import { Button } from 'lego-on-react';

import Dictionary from 'common/types/dictionary';

import { PeriodDateType } from 'client/store/common/types';

import 'lego-on-react/src/components/button/button.css';

import './bansAggregation.css';

import StatisticsDate from 'client/components/statisticsDate';
import StatisticsSelect from 'client/components/statisticsSelect';
import StatisticsContainer from 'client/components/statisticsContainer/statisticsContainer';

interface IBansAggregationProps {
    urlTemplate: string,
    examSlugs: Dictionary<string>,
    from: Date,
    to: Date,
    error?: PeriodDateType,
    interval?: string,
    exams: string[],
    intervals?: Dictionary<string>,
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseInterval(interval: string): void,
    chooseExams(exams: string[]): void
}

const b = cn('BansAggregation');

class BansAggregation extends Component<IBansAggregationProps> {
    public render() {
        const {
            from,
            to,
            error,
            interval,
            exams,
            examSlugs,
            intervals,
            changeFromDate,
            changeToDate,
            chooseInterval,
            chooseExams
        } = this.props;

        return (
            <div className={b()}>
                <StatisticsContainer
                    title="Сбор статистических данных по банам за указанный период"
                    >
                    <div className={b('Date')}>
                        <StatisticsDate
                            from={from}
                            to={to}
                            error={error}
                            changeFromDate={changeFromDate}
                            changeToDate={changeToDate}
                            />
                    </div>
                    <div className={b('Select')}>
                        <StatisticsSelect
                            tip="Интервал"
                            items={intervals}
                            type="radio"
                            value={interval}
                            handleChange={chooseInterval}
                            />
                    </div>
                    <div className={b('Select')}>
                        <StatisticsSelect
                            tip="Тестирование"
                            items={examSlugs}
                            type="check"
                            value={exams}
                            handleChange={chooseExams}
                            />
                    </div>
                    <div className={b('Button')}>
                        <Button
                            theme="action"
                            size="m"
                            text="Скачать отчёт"
                            disabled={this._isDisabled}
                            onClick={this._onSubmit}
                            />
                    </div>
                </StatisticsContainer>
            </div>
        );
    }

    private get _isDisabled() {
        const { from, to, interval, exams } = this.props;

        return !from || !to || !interval || !exams || exams.length === 0;
    }

    private readonly _onSubmit = () => {
        const { from, to, interval, exams, urlTemplate } = this.props;

        if (this._isDisabled) {
            return;
        }

        const query = stringify({
            from: from && from.toISOString(),
            to: to && to.toISOString(),
            interval,
            slug: exams
        });

        if (window) {
            window.location.href = `${urlTemplate}&${query}`;
        }
    };
}

export default BansAggregation;
