import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store/index';

import { BansAggregationAction } from 'client/store/bansAggregation/types';

import { PeriodDateType } from 'client/store/common/types';
import Dictionary from 'common/types/dictionary';

import {
    changeFromDate,
    changeToDate,
    chooseInterval,
    chooseExams
} from 'client/store/bansAggregation/actions';

import BansAggregation from './bansAggregation';

interface IStateProps {
    from: Date,
    to: Date,
    error?: PeriodDateType,
    interval?: string,
    exams: string[]
}

interface IOwnProps {
    urlTemplate: string,
    examSlugs: Dictionary<string>,
    intervals?: Dictionary<string>
}

type DataByPeriodProps = IStateProps & IOwnProps;

interface IDispatchProps {
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseInterval(interval: string): void,
    chooseExams(exams: string[]): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): DataByPeriodProps {
    const {
        from,
        to,
        error,
        interval,
        exams
    } = state.bansAggregation;
    const { urlTemplate, examSlugs } = ownProps;

    return {
        from,
        to,
        error,
        interval,
        exams,
        urlTemplate,
        examSlugs
    };
}

function mapDispatchToProps(dispatch: Dispatch<BansAggregationAction>): IDispatchProps {
    return bindActionCreators({
        changeFromDate,
        changeToDate,
        chooseInterval,
        chooseExams
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(BansAggregation);
