import React from 'react';

import StatisticsContainer from '../statisticsContainer';
import StatisticsInput from '../statisticsInput';

export interface IBansByLoginProps {
    inputText: string,
    isValid?: boolean,
    hasFocus: boolean,
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void,
    onSubmit(): void
}

const BansByLogin = (props: IBansByLoginProps) => {
    const {
        inputText,
        onSubmit,
        typeAction,
        hasFocus,
        isValid,
        focus,
        blur
    } = props;

    return (
        <StatisticsContainer title="Получение банов пользователя по логину">
            <StatisticsInput
                buttonText="Скачать отчёт"
                tip="Логин пользователя"
                placeholder="login"
                errorMessage={isValid ? undefined : 'Введите корректный логин'}
                inputText={inputText}
                hasFocus={hasFocus}
                typeAction={typeAction}
                onSubmit={onSubmit}
                focus={focus}
                blur={blur}
                />
        </StatisticsContainer>
    );
};

export default BansByLogin;
