import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import withStatistics from 'client/enhancements/withStatistics';
import { ApplicationState } from 'client/store/index';
import { ITypeAction } from 'client/store/bansByLogin/types';
import { typeAction, focus, blur } from 'client/store/bansByLogin/actions';

import BansByLogin, { IBansByLoginProps } from './bansByLogin';

interface IStateProps {
    inputText: string,
    hasFocus: boolean,
    isValid?: boolean
}

interface IOwnProps {
    urlTemplate: string
}

type BansByLoginProps = IStateProps & IOwnProps;

interface IDispatchProps {
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): BansByLoginProps {
    const { inputText, isValid, hasFocus } = state.bansByLogin;
    const { urlTemplate } = ownProps;

    return { inputText, isValid, hasFocus, urlTemplate };
}

function mapDispatchToProps(dispatch: Dispatch<ITypeAction>): IDispatchProps {
    return bindActionCreators({
        typeAction,
        focus,
        blur
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(withStatistics<IBansByLoginProps>({ queryParam: 'login' })(BansByLogin));
