import { cn } from '@bem-react/classname';
import { classnames } from '@bem-react/classnames';
import React, { Component } from 'react';

import { IBanInfo } from 'client/store/bans/types';

import './bansInfo.css';

import 'client/components/table/table.css';
import IExam from 'common/types/exam';

const b = cn('BansInfo');

interface BansInfoProps {
    exams: IExam[],
    bansInfo: IBanInfo[],
    isSuperbanned: boolean
}

class BansInfo extends Component<BansInfoProps> {
    public render() {
        /* eslint-disable complexity */
        const { bansInfo, exams, isSuperbanned } = this.props;

        return (
            <div className={b()}>
                <div className={b('Header')}>
                    <div className={b('Title')}>Баны:</div>
                    { isSuperbanned &&
                        <div className={b('Superban')}>
                            У пользователя супербан
                        </div>
                    }
                </div>
                <div className={b('TableWrapper')}>
                    <table className={classnames(b('Bans'), cn('Table')())}>
                        <thead>
                            <tr>
                                <th>Тест</th>
                                <th>Действие</th>
                                <th>Дата начала</th>
                                <th>Дата окончания</th>
                                <th>Кто забанил</th>
                                <th>Причина</th>
                            </tr>
                        </thead>
                        <tbody>
                            { bansInfo.map((banInfo: IBanInfo) => {
                                const {
                                    trialTemplateId,
                                    reason,
                                    admin: { login },
                                    action,
                                    isLast
                                } = banInfo;
                                const startedDate = new Date(banInfo.startedDate);
                                const expiredDate = banInfo.expiredDate ?
                                    new Date(banInfo.expiredDate) : '';
                                const key = `${trialTemplateId}_${banInfo.startedDate}`;
                                const examInfo = exams.find(exam => {
                                    return exam.id === trialTemplateId;
                                });
                                const examName = examInfo ? examInfo.slug : trialTemplateId;
                                const isActive = action === 'ban'
                                    && isLast
                                    && (!expiredDate || expiredDate >= new Date());
                                const actionName = action === 'ban' ? 'бан' : 'разбан';

                                return (
                                    <tr key={key} className={b('Row', { isActive })}>
                                        <td>{examName}</td>
                                        <td>{actionName}</td>
                                        <td>{startedDate.toLocaleString()}</td>
                                        <td>{expiredDate.toLocaleString()}</td>
                                        <td>{login}</td>
                                        <td>{reason || ''}</td>
                                    </tr>
                                );
                            })}
                        </tbody>
                    </table>
                </div>
            </div>

        );
    }
}

export default BansInfo;
