import { cn } from '@bem-react/classname';
import React, { Component } from 'react';
import { stringify } from 'query-string';

import { Button } from 'lego-on-react';

import StatisticsContainer from 'client/components/statisticsContainer/statisticsContainer';
import StatisticsDate from 'client/components/statisticsDate';
import StatisticsSelect from 'client/components/statisticsSelect';

import Dictionary from 'common/types/dictionary';

import { PeriodDateError } from 'client/store/common/types';

import 'lego-on-react/src/components/button/button.css';

import './certificatesByPeriod.css';

interface ICertificatesByPeriodProps {
    urlTemplate: string,
    from: Date,
    to: Date,
    error?: PeriodDateError,
    exams?: string[],
    examSlugs: Dictionary<string>,
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseExams(exams: string[]): void
}

const b = cn('CertificatesByPeriod');

class CertificatesByPeriod extends Component<ICertificatesByPeriodProps> {
    public render() {
        const {
            from,
            to,
            error,
            exams,
            examSlugs,
            changeFromDate,
            changeToDate,
            chooseExams
        } = this.props;

        return (
            <div className={b()}>
                <StatisticsContainer title="Получение всех сертификатов за указанный период">
                    <div className={b('Date')}>
                        <StatisticsDate
                            from={from}
                            to={to}
                            error={error}
                            changeFromDate={changeFromDate}
                            changeToDate={changeToDate}
                            />
                    </div>
                    <div className={b('Select')}>
                        <StatisticsSelect
                            tip="Тестирование"
                            items={examSlugs}
                            type="check"
                            value={exams}
                            handleChange={chooseExams}
                            />
                    </div>
                    <div className={b('Button')}>
                        <Button
                            theme="action"
                            size="m"
                            text="Скачать отчёт"
                            disabled={this._isDisabled}
                            onClick={this._onSubmit}
                            />
                    </div>
                </StatisticsContainer>
            </div>
        );
    }

    private get _isDisabled() {
        const { from, to, exams } = this.props;

        return !from || !to || !exams || exams.length === 0;
    }

    private readonly _onSubmit = () => {
        const { from, to, exams, urlTemplate } = this.props;

        if (!from || !to || this._isDisabled) {
            return;
        }

        const query = stringify({
            from: from.toISOString(),
            to: to.toISOString(),
            slug: exams
        });

        if (window) {
            window.location.href = `${urlTemplate}&${query}`;
        }
    };
}

export default CertificatesByPeriod;
