import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store/index';

import { CertificatesByPeriodAction } from 'client/store/certificatesByPeriod/types';

import { PeriodDateError } from 'client/store/common/types';

import {
    changeFromDate,
    changeToDate,
    chooseExams
} from 'client/store/certificatesByPeriod/actions';

import Dictionary from 'common/types/dictionary';

import CertificatesByPeriod from './certificatesByPeriod';

interface IStateProps {
    from: Date,
    to: Date,
    error?: PeriodDateError,
    exams?: string[]
}

interface IOwnProps {
    urlTemplate: string,
    examSlugs: Dictionary<string>
}

type CertificatesByPeriodProps = IStateProps & IOwnProps;

interface IDispatchProps {
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseExams(exams: string[]): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): CertificatesByPeriodProps {
    const {
        from,
        to,
        error,
        exams
    } = state.certificatesByPeriod;
    const { urlTemplate, examSlugs } = ownProps;

    return {
        from,
        to,
        error,
        exams,
        urlTemplate,
        examSlugs
    };
}

function mapDispatchToProps(dispatch: Dispatch<CertificatesByPeriodAction>): IDispatchProps {
    return bindActionCreators({
        changeFromDate,
        changeToDate,
        chooseExams
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(CertificatesByPeriod);
