import { cn } from '@bem-react/classname';
import { classnames } from '@bem-react/classnames';
import React from 'react';

import { ICertificatesInfo } from 'client/store/nullifyCertificate/types';

import 'client/components/table/table.css';

const b = cn('CertificatesInfo');

interface CertificatesInfoProps {
    certificatesInfo: ICertificatesInfo[]
}

export default function CertificatesInfo({ certificatesInfo }: CertificatesInfoProps) {
    return (
        <table className={classnames(b(), cn('Table')())}>
            <thead>
                <tr>
                    <th>Id сертификата</th>
                    <th>Логин пользователя</th>
                    <th>Сертификат аннулирован?</th>
                    <th>Дата получения</th>
                    <th>Дата окончания действия</th>
                    <th>Слаг экзамена</th>
                    <th>Id попытки</th>
                    <th>Попытка аннулирована?</th>
                </tr>
            </thead>
            <tbody>
                {certificatesInfo.map(certInfo => {
                    const confirmedDate = new Date(certInfo.confirmedDate);
                    const dueDate = new Date(certInfo.dueDate);

                    return (
                        <tr key={certInfo.id}>
                            <td>{certInfo.id}</td>
                            <td>{certInfo.login}</td>
                            <td>{certInfo.isActive ? 'Нет' : 'Да'}</td>
                            <td>{confirmedDate.toLocaleString()}</td>
                            <td>{dueDate.toLocaleString()}</td>
                            <td>{certInfo.examSlug}</td>
                            <td>{certInfo.trialId}</td>
                            <td>{certInfo.isTrialNullified ? 'Да' : 'Нет'}</td>
                        </tr>
                    );
                })}
            </tbody>
        </table>
    );
}
