import { cn } from '@bem-react/classname';
import React, { Component } from 'react';

import { Modal, Button } from 'lego-on-react';

import 'lego-on-react/src/components/modal/modal.css';
import 'lego-on-react/src/components/button/button.css';

import './confirmationModal.css';

interface IConfirmationModalProps {
    confirmationText: string,
    confirmText: string,
    declineText: string,
    visible?: boolean,
    onConfirm(): void,
    onDecline(): void
}

const b = cn('ConfirmationModal');

class ConfirmationModal extends Component<IConfirmationModalProps> {
    public componentDidMount() {
        if (window) {
            window.addEventListener('keydown', this._onKeyDown);
        }
    }

    public componentWillUnmount() {
        if (window) {
            window.removeEventListener('keydown', this._onKeyDown);
        }
    }

    public render() {
        const {
            confirmationText,
            confirmText,
            declineText,
            visible = false,
            onConfirm,
            onDecline
        } = this.props;

        return (
            <Modal visible={visible}>
                <div className={b()}>
                    <h1 className={b('Text')}>{confirmationText}</h1>
                    <div className={b('Buttons')}>
                        <div className={b('Button')}>
                            <Button
                                theme="action"
                                size="m"
                                text={confirmText}
                                onClick={onConfirm}
                                />
                        </div>
                        <div className={b('Button')}>
                            <Button
                                theme="normal"
                                size="m"
                                text={declineText}
                                onClick={onDecline}
                                />
                        </div>
                    </div>
                </div>
            </Modal>
        );
    }

    private readonly _onKeyDown = ({ key }: KeyboardEvent) => {
        const { onConfirm, visible } = this.props;

        if (visible && key === 'Enter') {
            onConfirm();
        }
    };
}

export default ConfirmationModal;
