import React from 'react';

import StatisticsContainer from '../statisticsContainer';
import StatisticsInput from '../statisticsInput';

export interface IDataByCertNumberProps {
    inputText: string,
    hasFocus: boolean
    isValid?: boolean,
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void,
    onSubmit(): void
}

const DataByCertNumber = (props: IDataByCertNumberProps) => {
    const {
        inputText,
        onSubmit,
        typeAction,
        hasFocus,
        focus,
        blur,
        isValid
    } = props;

    return (
        <StatisticsContainer title="Получение данных по номеру сертификата">
            <StatisticsInput
                buttonText="Скачать отчёт"
                tip="Номер сертификата"
                placeholder="12345"
                errorMessage={isValid ? undefined : 'Введите число'}
                onSubmit={onSubmit}
                inputText={inputText}
                hasFocus={hasFocus}
                typeAction={typeAction}
                focus={focus}
                blur={blur}
                />
        </StatisticsContainer>
    );
};

export default DataByCertNumber;
