import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import withStatistics from '../../enhancements/withStatistics';
import { ApplicationState } from '../../store/index';
import { ITypeAction } from '../../store/dataByCertNumber/types';
import { typeAction, focus, blur } from '../../store/dataByCertNumber/actions';

import DataByCertNumber, { IDataByCertNumberProps } from './dataByCertNumber';

interface IStateProps {
    inputText: string,
    hasFocus: boolean,
    isValid?: boolean
}

interface IOwnProps {
    urlTemplate: string
}

type DataByCertNumberProps = IStateProps & IOwnProps;

interface IDispatchProps {
    typeAction(inputText: string): void,
    focus(): void,
    blur(): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): DataByCertNumberProps {
    const { inputText, isValid, hasFocus } = state.dataByCertNumber;
    const { urlTemplate } = ownProps;

    return { inputText, isValid, hasFocus, urlTemplate };
}

function mapDispatchToProps(dispatch: Dispatch<ITypeAction>): IDispatchProps {
    return bindActionCreators({
        typeAction,
        focus,
        blur
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(withStatistics<IDataByCertNumberProps>({ queryParam: 'certId' })(DataByCertNumber));
