import { cn } from '@bem-react/classname';
import React, { Component } from 'react';
import qs from 'qs';
import IExamSettings from 'common/types/examSettings';

import ExamData from 'client/components/examData';
import EditExamForm from 'client/components/editExamForm';
import Tabs, { ITabItem } from 'client/components/tabs';
import { Roles } from 'common/types/adminData';

import { RouteComponentProps } from 'react-router';

import 'lego-on-react/src/components/modal/modal.css';
import 'lego-on-react/src/components/button/button.css';

import './editExam.css';

interface IOwnProps {
    exam: IExamSettings,
    userRoles: Roles[],
    isLocked: boolean
}

type EditExamProps = IOwnProps & RouteComponentProps<{}>;

const b = cn('EditExam');

class EditExam extends Component<EditExamProps> {
    private getInitialTab = (tabsItems: ITabItem[]) => {
        const { location } = this.props;
        const parsedQuery = qs.parse(location.search.slice(1));

        return parsedQuery.tab || tabsItems[0].name;
    };

    private hasEditAccess = () => {
        const { userRoles } = this.props;

        return userRoles.some(role => role === Roles.admin);
    };

    public render() {
        const { exam: { id, slug }, isLocked, userRoles } = this.props;
        const isReadonly = !this.hasEditAccess();

        const tabsItems = [
            {
                name: 'settings',
                text: 'Настройки теста',
                content: <EditExamForm slug={slug} isReadonly={isReadonly} />
            },
            {
                name: 'questions',
                text: 'Вопросы',
                content: <ExamData
                    examSlug={slug}
                    examId={id!}
                    userRoles={userRoles}
                    isLocked={isLocked}
                    />
            }
        ];

        const initialActiveTab = this.getInitialTab(tabsItems);

        return (
            <div className={b()}>
                <div className={b('Slug')}>/{slug}</div>
                <Tabs items={tabsItems} initialActiveTab={initialActiveTab} />
            </div>
        );
    }
}

export default EditExam;
