import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from '../../store';
import { IEditExamFormAction, ISaveFormError } from '../../store/editExamForm/types';
import {
    changeOgDescription,
    changeRules,
    changeDescription,
    changeSeoDescription,
    changeTimeLimit,
    changeTitle,
    switchTitleEdit,
    saveSettings
} from '../../store/editExamForm/actions';

import IExamSettings from '../../../common/types/examSettings';

import EditExamForm from './editExamForm';

interface IOwnProps {
    slug: string,
    isReadonly: boolean
}

interface IStateProps {
    timeLimit: number,
    rules: string,
    description: string,
    ogDescription: string,
    seoDescription: string,
    title: string,
    isEditingTitle: boolean,
    isSavePending: boolean,
    isSaveSuccess: boolean,
    saveError: ISaveFormError | null
}

type EditExamFormProps = IOwnProps & IStateProps;

interface IDispatchProps {
    changeTimeLimitAction(timeLimit: number): void,
    changeRulesAction(rules: string): void,
    changeDescriptionAction(description: string): void,
    changeSeoDescriptionAction(seoDescription: string): void,
    changeOgDescriptionAction(ogDescription: string): void,
    changeTitleAction(title: string): void,
    switchTitleEditAction(isEditingTitle: boolean): void,
    saveSettingsAction(exam: IExamSettings): void
}

function mapStateToProps(
    state: ApplicationState, ownProps: IOwnProps
): EditExamFormProps {
    const {
        timeLimit,
        title,
        rules,
        description,
        ogDescription,
        seoDescription,
        isEditingTitle,
        isSavePending,
        isSaveSuccess,
        saveError
    } = state.editExamForm;

    return {
        slug: ownProps.slug,
        isReadonly: ownProps.isReadonly,
        timeLimit,
        title,
        rules,
        description,
        ogDescription,
        seoDescription,
        isEditingTitle,
        isSavePending,
        isSaveSuccess,
        saveError
    };
}

function mapDispatchToProps(dispatch: Dispatch<IEditExamFormAction>): IDispatchProps {
    return bindActionCreators({
        changeTimeLimitAction: changeTimeLimit,
        changeRulesAction: changeRules,
        changeDescriptionAction: changeDescription,
        changeSeoDescriptionAction: changeSeoDescription,
        changeOgDescriptionAction: changeOgDescription,
        changeTitleAction: changeTitle,
        switchTitleEditAction: switchTitleEdit,
        saveSettingsAction: saveSettings
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps>(
    mapStateToProps,
    mapDispatchToProps
)(EditExamForm);
