import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import {
    IEditAnswerCorrectPayload,
    IToggleRemoveAnswerPayload,
    IExamDataAction,
    IChangeAnswerTextPayload
} from 'client/store/examData/types';
import {
    editAnswerCorrect,
    toggleRemoveAnswer,
    changeAnswerText
} from 'client/store/examData/actions';

import ExamAnswer from './examAnswer';

interface IDispatchProps {
    editAnswerCorrect(data: IEditAnswerCorrectPayload): void,
    toggleRemoveAnswer(data: IToggleRemoveAnswerPayload): void,
    changeAnswerText(data: IChangeAnswerTextPayload): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        editAnswerCorrect,
        toggleRemoveAnswer,
        changeAnswerText
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps,
    null,
    { withRef: true }
)(ExamAnswer);
