import { cn } from '@bem-react/classname';
import React, { Component, createRef, Fragment } from 'react';
import ExamAnswer from 'client/components/examAnswer';

import { Button } from 'lego-on-react';

import 'lego-on-react/src/components/button/button.css';
import './examAnswers.css';

import { IEditAnswers } from 'common/types/editTestData';
import { IAddAnswerPayload } from 'client/store/examData/types';

const b = cn('ExamAnswers');

interface ExamAnswersProps {
    sectionCode: string,
    categoryId: number,
    questionId: number,
    answers: IEditAnswers,
    isReadonly: boolean,
    addAnswer(data: IAddAnswerPayload): void
}

class ExamAnswers extends Component<ExamAnswersProps> {
    private readonly firstNewAnswerRef = createRef<any>();

    private readonly onAddAnswer = () => {
        const { sectionCode, categoryId, questionId, addAnswer } = this.props;

        addAnswer({
            sectionCode,
            categoryId,
            questionId
        });
    };

    private readonly renderNewAnswers = () => {
        const { answers, sectionCode, categoryId, questionId, isReadonly } = this.props;
        const answersIds = Object.keys(answers);
        const newAnswersIds = answersIds
            .filter((answerId: string) => {
                return answers[Number(answerId)].isNew;
            })
            .reverse();

        if (!newAnswersIds.length) {
            return null;
        }

        const firstAnswerId = newAnswersIds.shift();

        return (
            <Fragment>
                {
                    <ExamAnswer
                        key={firstAnswerId}
                        sectionCode={sectionCode}
                        categoryId={categoryId}
                        questionId={questionId}
                        answer={answers[Number(firstAnswerId)]}
                        isReadonly={isReadonly}
                        ref={this.firstNewAnswerRef}
                        />
                }
                {
                    newAnswersIds.map(answerId => {
                        return (
                            <ExamAnswer
                                key={answerId}
                                sectionCode={sectionCode}
                                categoryId={categoryId}
                                questionId={questionId}
                                answer={answers[Number(answerId)]}
                                isReadonly={isReadonly}
                                />
                        );
                    })
                }
            </Fragment>
        );
    };

    private readonly renderOldAnswers = () => {
        const { answers, sectionCode, categoryId, questionId, isReadonly } = this.props;
        const answersIds = Object.keys(answers);
        const oldAnswersIds = answersIds.filter((answerId: string) => {
            return !answers[Number(answerId)].isNew;
        });

        return (
            <Fragment>
                {
                    oldAnswersIds.map(answerId => {
                        return (
                            <ExamAnswer
                                key={answerId}
                                sectionCode={sectionCode}
                                categoryId={categoryId}
                                questionId={questionId}
                                answer={answers[Number(answerId)]}
                                isReadonly={isReadonly}
                                />
                        );
                    })
                }
            </Fragment>
        );
    };

    public componentDidUpdate(prevProps: Readonly<ExamAnswersProps>): void {
        const oldLength = Object.keys(prevProps.answers).length;
        const currentLength = Object.keys(this.props.answers).length;

        if (currentLength > oldLength) {
            this.firstNewAnswerRef.current.getWrappedInstance().focusEditable();
        }
    }

    public render() {
        const { isReadonly } = this.props;

        return (
            <div className={b()}>
                {
                    !isReadonly &&
                    <Button
                        cls={b('Add')}
                        theme="normal"
                        size="s"
                        text="Добавить ответ"
                        onClick={this.onAddAnswer}
                        />
                }
                { this.renderNewAnswers() }
                { this.renderOldAnswers() }
            </div>
        );
    }
}

export default ExamAnswers;
