import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import {
    IExamDataAction,
    IAddAnswerPayload
} from 'client/store/examData/types';
import { addAnswer } from 'client/store/examData/actions';

import ExamAnswers from './examAnswers';

interface IDispatchProps {
    addAnswer(data: IAddAnswerPayload): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        addAnswer
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps
)(ExamAnswers);
