import { cn } from '@bem-react/classname';
import React, { Component } from 'react';

import './examCategory.css';

import { TEditCategory } from 'common/types/editTestData';

import ExamElementRestore from 'client/components/examElementRestore';
import { Icon } from 'lego-on-react';
import { IToggleRemoveCategoryPayload } from 'client/store/examData/types';
import { questionsHasChanges } from 'client/store/examData/helpers';

const b = cn('ExamCategory');

interface ExamCategoryProps {
    category: TEditCategory,
    sectionCode: string,
    isReadonly: boolean,
    openCategory(sectionCode: string, categoryId: number): void,
    toggleRemoveCategory(data: IToggleRemoveCategoryPayload): void
}

class ExamCategory extends Component<ExamCategoryProps> {
    private onClick = () => {
        const { sectionCode, category, openCategory } = this.props;

        openCategory(sectionCode, category.id);
    };

    private readonly remove = () => {
        const { sectionCode, category: { id }, toggleRemoveCategory } = this.props;

        toggleRemoveCategory({
            sectionCode,
            categoryId: id,
            isRemoved: true
        });
    };

    private readonly restore = () => {
        const { sectionCode, category: { id }, toggleRemoveCategory } = this.props;

        toggleRemoveCategory({
            sectionCode,
            categoryId: id,
            isRemoved: false
        });
    };

    private readonly hasChanges = () => {
        const { category: { isNew, isChanged, questions } } = this.props;

        return isNew || isChanged || questionsHasChanges(questions);
    };

    public render() {
        const { category: { id, isRemoved }, isReadonly } = this.props;

        if (isRemoved) {
            return (
                <div className={b({ removed: true })}>
                    <ExamElementRestore
                        text="Восстановить категорию"
                        restoreAction={this.restore}
                        />
                </div>
            );
        }

        const hasChanges = this.hasChanges();

        return (
            <div className={b({ unsaved: hasChanges })}>
                <div
                    className={b('Remove', { hidden: isReadonly })}
                    onClick={this.remove}
                    >
                    <Icon cls={b('RemoveIcon')} type="gray-cross" />
                </div>
                <div className={b('Content')} onClick={this.onClick}>
                    <span className={b('Id')}>{id}</span>
                    { hasChanges &&
                        <span className={b('Unsaved')} title="Неопубликованные изменения">
                            <Icon type="dot" />
                        </span>
                    }
                </div>
            </div>
        );
    }
}

export default ExamCategory;
