import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { IExamDataAction, IToggleRemoveCategoryPayload } from 'client/store/examData/types';
import { openCategory, toggleRemoveCategory } from 'client/store/examData/actions';

import ExamCategory from './examCategory';

interface IDispatchProps {
    openCategory(sectionCode: string, categoryId: number): void,
    toggleRemoveCategory(data: IToggleRemoveCategoryPayload): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        openCategory,
        toggleRemoveCategory
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps
)(ExamCategory);
