import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store';
import { IExamDataAction } from 'client/store/examData/types';
import {
    loadFile,
    downloadJSON,
    publishExam,
    declineDeleteDraft,
    declinePublish,
    declineCancelChanges,
    deleteDraft,
    showDeleteDraftModal,
    showPublishModal,
    showCancelChangesModal,
    cancelChanges,
    startEdit,
    saveDraft,
    sendDraftForModeration
} from 'client/store/examData/actions';

import RequestStatus from 'common/types/requestStatus';
import { IDetailsError } from 'common/utils/error';
import { Roles } from 'common/types/adminData';
import ITestData from 'common/types/testData';
import IEditTestData from 'common/types/editTestData';
import DraftStatus from 'common/types/draftStatus';

import ExamData from './examData';

export interface IStateProps {
    draftStatus: DraftStatus | null,
    loadStatus: RequestStatus | null,
    publishStatus: RequestStatus | null,
    saveDraftStatus: RequestStatus | null,
    sendDraftForModerationStatus: RequestStatus | null,
    startEditStatus: RequestStatus | null,
    deleteDraftStatus: RequestStatus | null,
    requestError: IDetailsError | null,
    exam: ITestData | null,
    editData: IEditTestData | null,
    openedCategoryId: number | null,
    openedSectionCode: string | null,
    isVisiblePublishModal: boolean,
    isVisibleDeleteDraftModal: boolean,
    isVisibleCancelChangesModal: boolean,
    cancelChangesStatus: RequestStatus | null,
    isEditMode: boolean
}

interface IDispatchProps {
    loadFile(examSlug: string, formData: FormData): void,
    downloadJSON(examSlug: string): void,
    publishExam(examSlug: string, editData: IEditTestData, examId: number): void,
    declinePublish(): void,
    showPublishModal(): void,
    deleteDraft(examSlug: string): void,
    showDeleteDraftModal(): void,
    declineDeleteDraft(): void,
    startEdit(examSlug: string): void,
    saveDraft(examSlug: string, examId: number, editData: IEditTestData): void,
    sendDraftForModeration(examSlug: string, examId: number, editData: IEditTestData): void,
    cancelChanges(examSlug: string): void,
    showCancelChangesModal(): void,
    declineCancelChanges(): void
}

interface IOwnProps {
    examId: number,
    examSlug: string,
    userRoles: Roles[],
    isLocked: boolean
}

type ExamDataProps = IOwnProps & IStateProps;

function mapStateToProps(
    state: ApplicationState, ownProps: IOwnProps
): ExamDataProps {
    const {
        draftStatus,
        loadStatus,
        publishStatus,
        saveDraftStatus,
        sendDraftForModerationStatus,
        deleteDraftStatus,
        requestError,
        exam,
        editData,
        openedCategoryId,
        openedSectionCode,
        isVisiblePublishModal,
        isVisibleDeleteDraftModal,
        isVisibleCancelChangesModal,
        cancelChangesStatus,
        isEditMode,
        startEditStatus
    } = state.examData;
    const { examId, examSlug, userRoles, isLocked } = ownProps;

    return {
        draftStatus,
        examId,
        examSlug,
        userRoles,
        loadStatus,
        publishStatus,
        saveDraftStatus,
        sendDraftForModerationStatus,
        deleteDraftStatus,
        requestError,
        exam,
        editData,
        openedCategoryId,
        openedSectionCode,
        isVisiblePublishModal,
        isVisibleDeleteDraftModal,
        isVisibleCancelChangesModal,
        cancelChangesStatus,
        isEditMode,
        startEditStatus,
        isLocked
    };
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        loadFile,
        downloadJSON,
        publishExam,
        declinePublish,
        showPublishModal,
        deleteDraft,
        showDeleteDraftModal,
        declineDeleteDraft,
        startEdit,
        saveDraft,
        sendDraftForModeration,
        cancelChanges,
        showCancelChangesModal,
        declineCancelChanges
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(ExamData);
