import { cn } from '@bem-react/classname';
import React, { Component } from 'react';
import { Icon } from 'lego-on-react';

import './examElementRestore.css';

const b = cn('ExamElementRestore');

interface ExamElementRestoreProps {
    text: string,
    restoreAction(data: any): void
}

class ExamElementRestore extends Component<ExamElementRestoreProps> {
    public render() {
        const { text, restoreAction } = this.props;

        return (
            <div className={b()}>
                <span
                    className={b('Text')}
                    onClick={restoreAction}
                    >
                    <Icon cls={b('Icon')} type="restore" />
                    {text}
                </span>
            </div>
        );
    }
}

export default ExamElementRestore;
