import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import {
    IChangeQuestionTextPayload,
    IEditQuestionTypePayload,
    IExamDataAction,
    IToggleRemoveQuestionPayload
} from 'client/store/examData/types';
import {
    editQuestionType,
    toggleRemoveQuestion,
    changeQuestionText
} from 'client/store/examData/actions';

import ExamQuestion from './examQuestion';

interface IDispatchProps {
    editQuestionType(data: IEditQuestionTypePayload): void,
    toggleRemoveQuestion(data: IToggleRemoveQuestionPayload): void,
    changeQuestionText(data: IChangeQuestionTextPayload): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        editQuestionType,
        toggleRemoveQuestion,
        changeQuestionText
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps,
    null,
    { withRef: true }
)(ExamQuestion);
