import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import {
    IAddQuestionPayload,
    IEditCategoryQuantityPayload,
    IExamDataAction
} from 'client/store/examData/types';
import {
    editCategoryQuantity,
    addQuestion
} from 'client/store/examData/actions';

import ExamQuestions from './examQuestions';

interface IDispatchProps {
    editCategoryQuantity(data: IEditCategoryQuantityPayload): void,
    addQuestion(data: IAddQuestionPayload): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        editCategoryQuantity,
        addQuestion
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps
)(ExamQuestions);
