import { cn } from '@bem-react/classname';
import React, { Component, ReactNode } from 'react';
import { Icon, Modal } from 'lego-on-react';
import ExamQuestions from 'client/components/examQuestions';

import { validateQuestions } from 'client/store/examData/helpers';

import 'lego-on-react/src/components/modal/modal.css';

import './examQuestionsModal.css';
import IEditTestData from 'common/types/editTestData';
import { toastr } from 'react-redux-toastr';

const b = cn('ExamQuestionsModal');

interface IExamQuestionsModalProps {
    editData: IEditTestData,
    categoryId: number,
    sectionCode: string,
    anchorRef: ReactNode,
    isReadonly: boolean,
    closeCategory(): void,
}

class ExamQuestionsModal extends Component<IExamQuestionsModalProps> {
    private readonly showValidationErrors = (validationErrors: string[]) => {
        const details = validationErrors.join('</br>');

        toastr.error('Невалидные данные в черновике:', '', {
            component: <div dangerouslySetInnerHTML={{ __html: details }} />
        });
    };

    private readonly onCloseCategory = () => {
        const { editData, sectionCode, categoryId, closeCategory } = this.props;

        const validationErrors = validateQuestions({
            editData,
            sectionCode,
            categoryId
        });

        if (validationErrors.length > 0) {
            this.showValidationErrors(validationErrors);

            return;
        }

        closeCategory();
    };

    public render() {
        const {
            sectionCode,
            categoryId,
            editData,
            isReadonly
        } = this.props;

        return (
            <Modal
                theme="normal"
                visible
                cls={b()}
                // @ts-ignore
                motionless
                >
                <div className={b('Content')}>
                    <div className={b('Close')} onClick={this.onCloseCategory}>
                        <Icon cls={b('CloseIcon')} type="gray-cross" />
                    </div>
                    <ExamQuestions
                        editData={editData}
                        categoryId={categoryId}
                        sectionCode={sectionCode}
                        isReadonly={isReadonly}
                        />
                </div>
            </Modal>
        );
    }
}

export default ExamQuestionsModal;
