import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { IExamDataAction } from 'client/store/examData/types';
import { closeCategory } from 'client/store/examData/actions';

import ExamQuestionsModal from './examQuestionsModal';

interface IDispatchProps {
    closeCategory(): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        closeCategory
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps
)(ExamQuestionsModal);
