import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import {
    IAddCategoryPayload,
    IEditSectionAllowedFailsPayload,
    IExamDataAction,
    IToggleRemoveSectionPayload
} from 'client/store/examData/types';
import {
    editSectionAllowedFails,
    toggleRemoveSection,
    addCategory
} from 'client/store/examData/actions';

import ExamSection from './examSection';

interface IDispatchProps {
    editSectionAllowedFails(data: IEditSectionAllowedFailsPayload): void,
    toggleRemoveSection(data: IToggleRemoveSectionPayload): void,
    addCategory(data: IAddCategoryPayload): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        editSectionAllowedFails,
        toggleRemoveSection,
        addCategory
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps
)(ExamSection);
