import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import {
    IAddSectionPayload,
    IExamDataAction
} from 'client/store/examData/types';
import {
    addSection
} from 'client/store/examData/actions';

import ExamSections from './examSections';

interface IDispatchProps {
    addSection(data: IAddSectionPayload): void
}

function mapDispatchToProps(dispatch: Dispatch<IExamDataAction>): IDispatchProps {
    return bindActionCreators({
        addSection
    }, dispatch);
}

export default connect<null, IDispatchProps>(
    null,
    mapDispatchToProps
)(ExamSections);
