import { cn } from '@bem-react/classname';
import React from 'react';
import { Copyright, Link } from 'lego-on-react';

import 'lego-on-react/src/components/copyright/copyright.css';
import 'lego-on-react/src/components/link/link.css';
import './footer.css';

const b = cn('Footer');

interface FooterProps {
    start: number,
    tld: string
}

const Footer = (props: FooterProps) => {
    const { start, tld } = props;

    return (
        <div className={b()}>
            <div className={b('Column')}>
                <Link theme="normal" text="Обратная связь" url="mailto:expert-dev@yandex-team.ru" />
            </div>
            <div className={b('Right')}>
                <div className={b('Confidential')}>
                    <Link
                        theme="normal"
                        text="Конфиденциально"
                        url="https://wiki.yandex-team.ru/nda"
                        />
                    <div className={b('InfoText')}>
                        Коммерческая тайна ООО «Яндекс», 119021,
                        Россия, г. Москва, ул. Льва Толстого, д. 16
                    </div>
                </div>
                <div className={b('InfoText')}>
                    <Copyright start={start} contentRegion={tld} />
                </div>
            </div>
        </div>
    );
};

export default Footer;
