import { storiesOf } from '@storybook/react';
import React from 'react';

import Freezing from '../freezing';

const stubAction = () => ({});

storiesOf('Freezing', module)
    .add('plain', () => (
        <Freezing
            chooseForFreezeAction={stubAction}
            chooseForUnfreezeAction={stubAction}
            freezeAction={stubAction}
            unfreezeAction={stubAction}
            examsById={{
                1: 'direct',
                4: 'metrika',
                37: 'hello',
                38: 'direct-en',
                39: 'metrica-en'
            }}
            frozenExams={[]}
            availableForFreezeExams={[1, 4, 37, 38, 39]}
            examsForFreeze={[]}
            examsForUnfreeze={[]}
            />
    ))
    .add('selected for freeze', () => (
        <Freezing
            chooseForFreezeAction={stubAction}
            chooseForUnfreezeAction={stubAction}
            freezeAction={stubAction}
            unfreezeAction={stubAction}
            examsById={{
                1: 'direct',
                4: 'metrika',
                37: 'hello',
                38: 'direct-en',
                39: 'metrica-en'
            }}
            frozenExams={[]}
            availableForFreezeExams={[1, 4, 37, 38, 39]}
            examsForFreeze={[1, 4]}
            examsForUnfreeze={[]}
            />
    ))
    .add('freeze success', () => (
        <Freezing
            chooseForFreezeAction={stubAction}
            chooseForUnfreezeAction={stubAction}
            freezeAction={stubAction}
            unfreezeAction={stubAction}
            examsById={{
                1: 'direct',
                4: 'metrika',
                37: 'hello',
                38: 'direct-en',
                39: 'metrica-en'
            }}
            frozenExams={[1, 4, 37]}
            availableForFreezeExams={[38, 39]}
            examsForFreeze={[]}
            examsForUnfreeze={[]}
            lastAttemptFinish={'2018-12-10T08:30:00.000Z'}
            />
    ))
    .add('unfreeze success', () => (
        <Freezing
            chooseForFreezeAction={stubAction}
            chooseForUnfreezeAction={stubAction}
            freezeAction={stubAction}
            unfreezeAction={stubAction}
            examsById={{
                1: 'direct',
                4: 'metrika',
                37: 'hello',
                38: 'direct-en',
                39: 'metrica-en'
            }}
            frozenExams={[1, 4, 37]}
            availableForFreezeExams={[38, 39]}
            examsForFreeze={[]}
            examsForUnfreeze={[]}
            isUnfrozenSuccess
            />
    ));
