import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import Dictionary from 'common/types/dictionary';

import { ApplicationState } from '../../store';
import { FreezeAction } from '../../store/freeze/types';
import { freeze, unfreeze, chooseForFreeze, chooseForUnfreeze } from '../../store/freeze/actions';

import Freezing from './freezing';

interface IOwnProps {
    examsById: Dictionary<string>
}

interface IStateProps {
    isUnfrozenSuccess?: Boolean,
    lastAttemptFinish?: string | null,
    isError?: Boolean,
    examsForFreeze: number[],
    examsForUnfreeze: number[],
    frozenExams: number[],
    availableForFreezeExams: number[]
}

type FreezingProps = IStateProps & IOwnProps;

interface IDispatchProps {
    freezeAction(exams: number[]): void,
    unfreezeAction(exams: number[]): void,
    chooseForFreezeAction(exams: number[]): void,
    chooseForUnfreezeAction(exams: number[]): void
}

function mapStateToProps(
    state: ApplicationState, ownProps: IOwnProps
): FreezingProps {
    const {
        isUnfrozenSuccess,
        lastAttemptFinish,
        isError,
        examsForFreeze,
        examsForUnfreeze,
        frozenExams,
        availableForFreezeExams
    } = state.freeze;

    return {
        isUnfrozenSuccess,
        lastAttemptFinish,
        isError,
        frozenExams,
        availableForFreezeExams,
        examsForFreeze,
        examsForUnfreeze,
        examsById: ownProps.examsById
    };
}

function mapDispatchToProps(dispatch: Dispatch<FreezeAction>): IDispatchProps {
    return bindActionCreators({
        freezeAction: freeze,
        unfreezeAction: unfreeze,
        chooseForFreezeAction: chooseForFreeze,
        chooseForUnfreezeAction: chooseForUnfreeze
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(Freezing);
