import { cn } from '@bem-react/classname';
import React, { Component } from 'react';

import HeaderMenu, { IMenuItem } from '../headerMenu';
import Dictionary from '../../../common/types/dictionary';

import './header.css';

const b = cn('Header');

interface HeaderProps {
    userInfo: {
        staff: string,
        avatar: string
    },
    accessToPages: Dictionary<boolean>
}

class Header extends Component<HeaderProps> {
    private readonly menuItems: IMenuItem[] = [
        {
            url: '/',
            content: 'Отчёты',
            name: 'reports',
            match: { path: '/', exact: true }
        },
        {
            url: '/admin',
            content: 'Тесты',
            name: 'admin',
            match: { path: '/admin', exact: false }
        },
        {
            url: '/dev',
            content: 'Заморозка',
            name: 'dev',
            match: { path: '/dev', exact: true }
        },
        {
            url: '/videos',
            content: 'Пересмотр',
            name: 'videos',
            match: { path: '/videos', exact: true }
        },
        {
            url: '/nullify',
            content: 'Аннулирование',
            name: 'nullify',
            match: { path: '/nullify', exact: true }
        },
        {
            url: '/bans',
            content: 'Бан',
            name: 'bans',
            match: { path: '/bans', exact: true }
        }
    ];

    private getAvailableMenuItems = () => {
        const { accessToPages } = this.props;

        return this.menuItems.filter((item: IMenuItem) => accessToPages[item.name]);
    };

    private readonly logoUrl =
        'https://yastatic.net/q/logoaas/v1/Яндекс%20Сертификация.svg?color=000';

    render() {
        const { staff, avatar } = this.props.userInfo;
        const availableMenuItems = this.getAvailableMenuItems();

        const left = [
            {
                role: 'logo',
                content: (
                    <div
                        key="logo-wrapper"
                        className={b('LogoWrapper')}
                        >
                        <img className={b('Logoaas')} src={this.logoUrl} />
                    </div>
                )
            },
            {
                role: 'menu',
                content: <HeaderMenu key="header-menu" menu={availableMenuItems} />
            }
        ];

        const right = [
            {
                role: 'user',
                content: (
                    <a key="header-user" className={b('User')} href={staff}>
                        <img
                            className={b('UserAvatar')}
                            src={avatar}
                            />
                    </a>
                )
            }
        ];

        return (
            <div className={b()}>
                <div className={b('Left')}>
                    {left.map(item => (
                        <div
                            key={`${item.role}`}
                            className={b('Item', { left: true })}
                            >
                            {item.content}
                        </div>
                    ))}
                </div>
                <div className={b('Right')}>
                    {right.map(item => (
                        <div
                            key={`${item.role}`}
                            className={b('Item', { right: true })}
                            >
                            {item.content}
                        </div>
                    ))}
                </div>
            </div>
        );
    }
}

export default Header;
