import { cn } from '@bem-react/classname';
import React, { PureComponent } from 'react';
import { matchPath, RouteComponentProps } from 'react-router-dom';

import './headerMenu.css';

const b = cn('HeaderMenu');

interface IMatchParams {
    path: string,
    exact?: boolean,
    strict?: boolean
}

export interface IMenuItem {
    match: IMatchParams,
    url: string,
    content: string,
    name: string
}

interface OwnProps {
    menu: IMenuItem[]
}

type HeaderMenuProps = RouteComponentProps<{}> & OwnProps;

export default class HeaderMenu extends PureComponent<HeaderMenuProps> {
    private readonly _isCurrentPage = (item: IMenuItem) => {
        const { location } = this.props;
        const matches = matchPath(location.pathname, item.match);

        return Boolean(matches);
    };

    render() {
        const { menu } = this.props;

        return (
            <ul className={b()}>
                {menu.map((item: IMenuItem) => (
                    <li
                        className={b('Item', { active: this._isCurrentPage(item) })}
                        key={item.name}
                        >
                        <a
                            className={b('ItemContent')}
                            href={item.url}
                            >
                            {item.content}
                        </a>
                        <span className={b('Border')} />
                    </li>
                ))}
            </ul>
        );
    }
}
