import { cn } from '@bem-react/classname';
import React, { ReactNode } from 'react';

import './layout.css';

const b = cn('Layout');

interface ILayoutProps {
    children: ReactNode,
    type?: 'Fullpage' | 'Column'
}

const Layout = (props: ILayoutProps) => {
    const { children, type = 'Column' } = props;

    return (
        <div className={b()}>
            <div className={b(type)}>{children}</div>
        </div>
    );
};

export default Layout;
