import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store/index';

import {
    NullifyAttemptsAction,
    IAttemptInfo
} from 'client/store/nullifyAttempt/types';

import { IDetailsError } from 'common/utils/error';

import {
    typeAttemptIdsAction,
    focusAttemptIds,
    blurAttemptIds,
    getAttemptsInfo,
    showConfirmation,
    decline,
    confirm
} from 'client/store/nullifyAttempt/actions';

import NullifyAttempt from './nullifyAttempt';

interface IStateProps {
    attemptIds: string,
    hasFocusAttemptIds: boolean,
    isValidAttemptIds: boolean,
    hasAttemptIds: boolean,
    isPending: boolean,
    requestError: IDetailsError | null,
    isVisibleConfirmationModal: boolean,
    attemptsInfo: IAttemptInfo[] | null,
    isNullifySuccess: boolean,
    notFoundAttempts: number[] | null
}

interface IDispatchProps {
    typeAttemptIdsAction(inputText: string): void,
    focusAttemptIds(): void,
    blurAttemptIds(): void,
    getAttemptsInfo(attemptIds: string): void,
    showConfirmation(): void,
    decline(): void,
    confirm(attemptIds: string): void
}

function mapStateToProps(state: ApplicationState): IStateProps {
    const {
        attemptIds,
        hasFocusAttemptIds,
        isValidAttemptIds,
        hasAttemptIds,
        attemptsInfo,
        isPending,
        requestError,
        isVisibleConfirmationModal,
        isNullifySuccess,
        notFoundAttempts
    } = state.nullifyAttempt;

    return {
        attemptIds,
        hasFocusAttemptIds,
        isValidAttemptIds,
        hasAttemptIds,
        attemptsInfo,
        isPending,
        requestError,
        isVisibleConfirmationModal,
        isNullifySuccess,
        notFoundAttempts
    };
}

function mapDispatchToProps(dispatch: Dispatch<NullifyAttemptsAction>): IDispatchProps {
    return bindActionCreators({
        typeAttemptIdsAction,
        focusAttemptIds,
        blurAttemptIds,
        getAttemptsInfo,
        showConfirmation,
        confirm,
        decline
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps>(
    mapStateToProps,
    mapDispatchToProps
)(NullifyAttempt);
