import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store/index';

import {
    NullifyCertificatesAction,
    ICertificatesInfo
} from 'client/store/nullifyCertificate/types';

import {
    typeCertificateIdsAction,
    focusCertificateIds,
    blurCertificateIds,
    getCertificatesInfo,
    showConfirmation,
    decline,
    confirm
} from 'client/store/nullifyCertificate/actions';

import { IDetailsError } from 'common/utils/error';
import RequestStatus from 'common/types/requestStatus';

import NullifyCertificate from './nullifyCertificate';

interface IStateProps {
    certIds: string,
    isValidCertIds: boolean,
    hasFocusCertIds: boolean,
    nullifyCertsStatus: RequestStatus | null,
    getInfoStatus: RequestStatus | null,
    requestError: IDetailsError | null,
    isVisibleConfirmationModal: boolean,
    certificatesInfo: ICertificatesInfo[] | null
}

interface IDispatchProps {
    typeCertificateIdsAction(inputText: string): void,
    focusCertificateIds(): void,
    blurCertificateIds(): void,
    getCertificatesInfo(certIds: string): void,
    showConfirmation(): void,
    decline(): void,
    confirm(certIds: string): void
}

function mapStateToProps(state: ApplicationState): IStateProps {
    const {
        certIds,
        isValidCertIds,
        hasFocusCertIds,
        nullifyCertsStatus,
        getInfoStatus,
        requestError,
        isVisibleConfirmationModal,
        certificatesInfo
    } = state.nullifyCertificate;

    return {
        certIds,
        isValidCertIds,
        hasFocusCertIds,
        nullifyCertsStatus,
        getInfoStatus,
        requestError,
        isVisibleConfirmationModal,
        certificatesInfo
    };
}

function mapDispatchToProps(dispatch: Dispatch<NullifyCertificatesAction>): IDispatchProps {
    return bindActionCreators({
        typeCertificateIdsAction,
        focusCertificateIds,
        blurCertificateIds,
        getCertificatesInfo,
        showConfirmation,
        confirm,
        decline
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps>(
    mapStateToProps,
    mapDispatchToProps
)(NullifyCertificate);
