import { cn } from '@bem-react/classname';
import React, { PureComponent } from 'react';

import { Button, Icon, TextInput } from 'lego-on-react';

import 'lego-on-react/src/components/button/button.css';
import 'lego-on-react/src/components/textinput/textinput.css';

import './numberInput.css';

const b = cn('NumberInput');

export interface INumberInputProps {
    name?: string,
    min?: number,
    max?: number,
    step?: number,
    value?: number,
    inputId?: number,
    disabled?: boolean
    typeAction(inputText: number): void
}

class NumberInput extends PureComponent<INumberInputProps> {
    private onStepDown = () => {
        const { value = 0, step = 1, min = -Infinity, typeAction } = this.props;

        if (value > min) {
            typeAction(Number(value) - step);
        }
    };

    private onStepUp = () => {
        const { value = 0, step = 1, max = Infinity, typeAction } = this.props;

        if (value < max) {
            typeAction(Number(value) + step);
        }
    };

    private onInputChange = (inputText: any) => {
        const { typeAction } = this.props;

        typeAction(inputText);
    };

    public render() {
        const {
            min,
            max,
            value,
            disabled
        } = this.props;

        return (
            <div className={b()}>
                <Button
                    theme="normal"
                    size="s"
                    cls={b('Subtract')}
                    disabled={disabled}
                    icon={<Icon type="minus" />}
                    onClick={this.onStepDown}
                    />
                <TextInput
                    theme="normal"
                    size="s"
                    type="number"
                    controlAttrs={
                        {
                            min,
                            max
                        }
                    }
                    text={value}
                    cls={b('Input')}
                    onChange={this.onInputChange}
                    disabled={disabled}
                    pin="round-round"
                    />
                <Button
                    theme="normal"
                    size="s"
                    cls={b('Add')}
                    disabled={disabled}
                    icon={<Icon type="plus" />}
                    onClick={this.onStepUp}
                    />
            </div>
        );
    }
}

export default NumberInput;
