import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store';

import { QuestionsStatisticsAction } from 'client/store/questionsStatistics/types';

import { PeriodDateType } from 'client/store/common/types';
import Dictionary from 'common/types/dictionary';

import {
    changeFromDate,
    changeToDate,
    chooseExams
} from 'client/store/questionsStatistics/actions';

import QuestionsStatistics from './questionsStatistics';

interface IStateProps {
    from?: Date,
    to?: Date,
    error?: PeriodDateType,
    exams?: string[]
}

interface IOwnProps {
    urlTemplate: string,
    examSlugs?: Dictionary<string>
}

type QuestionsStatisticsProps = IStateProps & IOwnProps;

interface IDispatchProps {
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseExams(exams: string[]): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): QuestionsStatisticsProps {
    const {
        from,
        to,
        error,
        exams
    } = state.questionsStatistics;
    const { urlTemplate, examSlugs } = ownProps;

    return {
        from,
        to,
        error,
        exams,
        urlTemplate,
        examSlugs
    };
}

function mapDispatchToProps(dispatch: Dispatch<QuestionsStatisticsAction>): IDispatchProps {
    return bindActionCreators({
        changeFromDate,
        changeToDate,
        chooseExams
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(QuestionsStatistics);
