import { cn } from '@bem-react/classname';
import React, { Component } from 'react';
import { stringify } from 'query-string';

import { Button } from 'lego-on-react';

import Dictionary from 'common/types/dictionary';

import { PeriodDateType } from 'client/store/common/types';

import 'lego-on-react/src/components/button/button.css';
import 'lego-on-react/src/components/textarea/textarea.css';

import './questionsStatistics.css';

import StatisticsDate from 'client/components/statisticsDate';
import StatisticsSelect from 'client/components/statisticsSelect';
import StatisticsContainer from 'client/components/statisticsContainer/statisticsContainer';

interface IQuestionsStatisticsProps {
    urlTemplate: string,
    examSlugs?: Dictionary<string>,
    from?: Date,
    to?: Date,
    error?: PeriodDateType,
    exams?: string[],
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseExams(exams: string[]): void
}

const b = cn('QuestionsStatistics');

class QuestionsStatistics extends Component<IQuestionsStatisticsProps> {
    public render() {
        const {
            from,
            to,
            error,
            exams,
            examSlugs,
            changeFromDate,
            changeToDate,
            chooseExams
        } = this.props;

        return (
            <div className={b()}>
                <StatisticsContainer title="Получение статистики по ответам на вопросы">
                    <div className={b('Date')}>
                        <StatisticsDate
                            from={from}
                            to={to}
                            error={error}
                            changeFromDate={changeFromDate}
                            changeToDate={changeToDate}
                            />
                    </div>
                    <div className={b('Select')}>
                        <StatisticsSelect
                            tip="Тестирование"
                            items={examSlugs}
                            type="radio"
                            value={exams}
                            handleChange={chooseExams}
                            />
                    </div>
                    <div className={b('Button')}>
                        <Button
                            theme="action"
                            size="m"
                            text="Скачать отчёт"
                            disabled={this.isDisabled}
                            onClick={this.onSubmit}
                            />
                    </div>
                </StatisticsContainer>
            </div>
        );
    }

    private get isDisabled() {
        const { from, to, exams } = this.props;

        return !from || !to || !exams || exams.length === 0;
    }

    private readonly getQuery = () => {
        const { from, to, exams } = this.props;

        return stringify({
            from: from && from.toISOString(),
            to: to && to.toISOString(),
            slug: exams
        });
    };

    private readonly onSubmit = () => {
        const { urlTemplate } = this.props;

        if (this.isDisabled) {
            return;
        }

        const query = this.getQuery();

        if (window) {
            window.location.href = `${urlTemplate}&${query}`;
        }
    };

}

export default QuestionsStatistics;
