import { cn } from '@bem-react/classname';
import React, { ReactNode } from 'react';

import './statisticsContainer.css';

const b = cn('StatisticsContainer');

interface IStatisticsContainerProps {
    title: string,
    children?: ReactNode
}

const Statistics = (props: IStatisticsContainerProps) => {
    const {
        title,
        children
    } = props;

    return (
        <div className={b()}>
            <h3 className={b('Title')}>{title}</h3>
            <div className={b('Content')}>
                {children}
            </div>
        </div>
    );
};

export default Statistics;
