import { cn } from '@bem-react/classname';
import React, { Component, createRef } from 'react';

import { Tooltip } from 'lego-on-react';

import DatePicker from 'react-datepicker';

import { PeriodDateType } from '../../store/common/types';

import 'react-datepicker/dist/react-datepicker.css';

import './statisticsDate.css';

interface IStatisticsDateProps {
    from?: Date,
    to?: Date,
    error?: PeriodDateType,
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void
}

const b = cn('StatisticsDate');

const dateFormat = 'dd.MM.yyyy';
const errorMessage = 'Некорректный интервал';

class StatisticsDate extends Component<IStatisticsDateProps> {
    private readonly _fromRef = createRef<HTMLDivElement>();
    private readonly _toRef = createRef<HTMLDivElement>();

    private renderDatePicker(
        isServer: boolean,
        onChange: (date: Date) => void,
        selected?: Date,
    ) {
        return isServer ? '' : (
            <DatePicker
                selected={selected}
                onChange={onChange}
                dateFormat={dateFormat}
                />
        );
    }

    public render() {
        const {
            from,
            to,
            changeFromDate,
            changeToDate,
            error
        } = this.props;

        const isServer = typeof window === 'undefined';

        return (
            <div className={b()}>
                <div ref={this._fromRef} className={b('Input')}>
                    {this.renderDatePicker(isServer, changeFromDate, from)}
                </div>

                <Tooltip
                    anchor={this._fromRef.current}
                    theme="error"
                    size="m"
                    to="top"
                    visible={error === 'from'}
                    >
                    {errorMessage}
                </Tooltip>

                <div ref={this._toRef} className={b('Input')}>
                    {this.renderDatePicker(isServer, changeToDate, to)}
                </div>

                <Tooltip
                    anchor={this._toRef.current}
                    theme="error"
                    size="m"
                    to="top"
                    visible={error === 'to'}
                    >
                    {errorMessage}
                </Tooltip>
            </div>
        );
    }
}

export default StatisticsDate;
